
#include <stdio.h>

#include "system.h"

#include "altera_avalon_pio_regs.h"

#include "alt_types.h"

#include "sys/alt_irq.h"

#include "priv/alt_busy_sleep.h"

#define LEDCON 0x01

#define KEYCON 0x01

#define left 5
#define right 700

#define down  50
#define  up 450


#define center_x 340
#define center_y 250

#define speed_normal 5000;
#define speed_high 2500;
#define speed_low  10000;


volatile alt_u32 done = 0;     //flaginform an interruption

volatile alt_u32 temp=0;

    volatile alt_u32  x_pingpong=400;
    volatile alt_u32  y_pingpong=150;
    volatile alt_u32  x_y_pingpong=0;

   volatile alt_u32   ltm_x;
   volatile alt_u32   ltm_y;
   volatile alt_u32   ltm_y_x;


   volatile alt_u32   left_x=100;
   volatile alt_u32   left_y=150;
   volatile alt_u32   left_y_x;


   volatile alt_u32   right_x=600;
   volatile alt_u32   right_y=150;
   volatile alt_u32   right_y_x;


   volatile alt_u32   score1=0;
   volatile alt_u32   score2=0;
   volatile alt_u32   score3=0;
   volatile alt_u32   score4=0;


   volatile alt_u32   score;



   volatile alt_u32   x_count;
   volatile alt_u32   y_count;

  volatile alt_u32   flag;
     volatile alt_u32   flag1;

 volatile alt_u32  count_r=0;
 volatile alt_u32  count_l=0;  // score of the left side


   volatile alt_u32  speed=speed_normal;



#define PIO_LED_BASE 0x00101020

static void KeyDown_interrupts(void* context, alt_u32 id)

{



    IOWR_ALTERA_AVALON_PIO_EDGE_CAP(PIO_KEY_BASE, ~KEYCON);


   ltm_y_x=IORD_ALTERA_AVALON_PIO_DATA(PIO_SW_BASE);
   ltm_x=(ltm_y_x>>12)*800/4095;
   ltm_y=(ltm_y_x & 0xfff)*480/4095;


   if (x_pingpong<center_x && ltm_x<center_x)
     {
       left_x=ltm_x-20;
       left_y=ltm_y;
     }


    if (x_pingpong>center_x && ltm_x>center_x)
     {
       right_x=ltm_x;
       right_y=ltm_y;
     }


     if (flag==0)
         {
           flag=1;
           score1=0;
           score2=0;
           score3=0;
           score4=0;
           count_r=0;
           count_l=0;
         }

     flag1=1;

  if (ltm_x>0 && ltm_x<100 && ltm_y>0 && ltm_y<60)
     speed=speed_low;

  if (ltm_x>(center_x-30) && ltm_x<(center_x+80) && ltm_y>0 && ltm_y<60)
     speed=speed_normal;

  if (ltm_x>right && ltm_x<(right+60) && ltm_y>0 && ltm_y<60)
     speed=speed_high;

}


void InitPIO(void)

{


    IOWR_ALTERA_AVALON_PIO_DIRECTION(PIO_KEY_BASE, ~KEYCON); //input 0

    IOWR_ALTERA_AVALON_PIO_DIRECTION(PIO_LED_BASE, LEDCON); //input 1


    IOWR_ALTERA_AVALON_PIO_IRQ_MASK(PIO_KEY_BASE, KEYCON);  //open PIO_KEY interrupt


    IOWR_ALTERA_AVALON_PIO_EDGE_CAP(PIO_KEY_BASE, ~KEYCON);  //clear the edge capturing register

    /* register the interrupts */
    alt_irq_register(PIO_KEY_IRQ, NULL, KeyDown_interrupts);

}




void main(void)

{
      flag=0;

       x_count=-1;
       y_count=-1;
        int start=0;                   //start of the whole game
        int beginL=0,beginR=0;         // flag for the serve side
        int play=1;                  // flag of the whole game


    volatile alt_u32 key_state, old_state, new_state;


    old_state = KEYCON;

    IOWR_ALTERA_AVALON_PIO_DATA(PIO_LED_BASE, old_state);  //initializing LED and extinguish it

    InitPIO();
    right_y_x=right_x+right_y*2048;
    left_y_x=left_x+left_y*2048;
    score=score1+(score2<<4)+(score3<<8)+(score4<<12);
             x_pingpong=center_x;
            y_pingpong=center_y;

    while(1)

        {
             right_y_x=ltm_x+ltm_y*2048;
             left_y_x=left_x+left_y*2048;
             score=score1+(score2<<4)+(score3<<8)+(score4<<12);
             x_y_pingpong=y_pingpong*2048+x_pingpong;



                alt_busy_sleep(50000);          //delay5ms

                key_state = IORD_ALTERA_AVALON_PIO_DATA(PIO_KEY_BASE)&KEYCON;

                if(key_state == 0xFF)          //interrupt caused by pulse

                    continue;                   //remove keyboard jitter

                new_state = ~(old_state^key_state);  //get the new state

                old_state = new_state;         //save the status of LED

                IOWR_ALTERA_AVALON_PIO_DATA(PIO_LED_BASE, score);
                IOWR_ALTERA_AVALON_PIO_DATA( PIO_PINGPONG_BASE,x_y_pingpong);
                IOWR_ALTERA_AVALON_PIO_DATA( PIO_LEFT_BASE,left_y_x);
                IOWR_ALTERA_AVALON_PIO_DATA( PIO_RIGHT_BASE,right_y_x);



             while(flag && flag1)
             {

                x_pingpong=x_pingpong+x_count;
                y_pingpong=y_pingpong+y_count;

            //    if (right <=x_pingpong)
              //      x_count=-1;
                if (x_pingpong>(right_x-20 )&& x_pingpong <(right_x+20) && y_pingpong>(right_y-20)&& y_pingpong<right_y+20)
                   x_count=-1;
              // if (left>=x_pingpong)
              //     x_count=1;

                if (x_pingpong>(left_x-20) && x_pingpong<(left_x+20) && y_pingpong>(left_y-20)&& y_pingpong<left_y+20)
                   x_count=1;

                 if (up<=y_pingpong)
                  y_count=-1;
                 if (down >=y_pingpong)
                  y_count=1;

                 right_y_x=right_x+right_y*2048;
                 left_y_x=left_x+left_y*2048;
                score=score1+(score2<<4)+(score3<<8)+(score4<<12);
                x_y_pingpong=y_pingpong*2048+x_pingpong;

                IOWR_ALTERA_AVALON_PIO_DATA(PIO_LED_BASE, score);
                IOWR_ALTERA_AVALON_PIO_DATA( PIO_PINGPONG_BASE,x_y_pingpong);
                IOWR_ALTERA_AVALON_PIO_DATA( PIO_LEFT_BASE,left_y_x);
                IOWR_ALTERA_AVALON_PIO_DATA( PIO_RIGHT_BASE,right_y_x);
                alt_busy_sleep(speed);  /// speed

                 if (x_pingpong<=left)
                   {
                     count_r++;
                     x_pingpong=center_x;
                     y_pingpong=center_y;
                     x_count=1;
                     y_count=-1;
                     flag1=0;

                   }

                if (x_pingpong>=right)
                {
                     count_l++;
                    x_pingpong=center_x;
                     y_pingpong=center_y;
                     x_count=-1;
                     y_count=-1;
                     flag1=0;

                }

                if (count_r>=10)
                  {
                     score3=1;
                     score4=count_r-10;
                  }
               else
                 {
                     score3=0;
                     score4=count_r;
                  }

              if (count_l>=10)
                  {
                     score1=1;
                     score2=count_l-10;
                  }
              else
                 {
                     score1=0;
                     score2=count_l;
                  }



                if( count_r==11 || count_l==11)
                {
                    flag=0;
                    x_pingpong=center_x;
                    y_pingpong=center_y;

                    right_x=650;
                    right_y=150;

                    left_x=100;
                    left_y=150;
                }


             }



         }

}
